/* -------------------------------------
   Author: prabhjot Kaur
   Student #: 991804196
-------------------------------------- */

const products = [
    { id: 1, name: "Wireless Headphones", price: 49.99, category: "electronics", description: "Noise-cancelling Bluetooth headphones.", image: "images/product1.jpg" },
    { id: 2, name: "Cotton T-Shirt", price: 19.99, category: "clothing", description: "Comfortable and breathable cotton t-shirt.", image: "images/product2.jpg" },
    { id: 3, name: "Coffee Maker", price: 89.99, category: "home", description: "Automatic drip coffee machine with timer.", image: "images/product3.jpg" },
    { id: 4, name: "Smart Watch", price: 129.99, category: "electronics", description: "Track your fitness and notifications.", image: "images/product4.jpg" }
];

let cart = [];

const productContainer = document.getElementById("products");
const cartContainer = document.getElementById("cartItems");
const grandTotal = document.getElementById("grandTotal");
const clearCartBtn = document.getElementById("clearCart");
const categoryFilter = document.getElementById("categoryFilter");
const darkModeToggle = document.getElementById("darkModeToggle");

function displayProducts(filter = "all") {
    productContainer.innerHTML = "";
    const filteredProducts = filter === "all" ? products : products.filter(p => p.category === filter);

    filteredProducts.forEach(product => {
        const card = document.createElement("div");
        card.classList.add("product-card");
        card.innerHTML = `
            <img src="${product.image}" alt="${product.name}">
            <h3>${product.name}</h3>
            <p>${product.description}</p>
            <p><strong>$${product.price.toFixed(2)}</strong></p>
            <button onclick="addToCart(${product.id})">Add to Cart</button>
        `;
        productContainer.appendChild(card);
    });
}

function addToCart(id) {
    const product = products.find(p => p.id === id);
    const existing = cart.find(item => item.id === id);

    if (existing) {
        existing.quantity++;
    } else {
        cart.push({ ...product, quantity: 1 });
    }
    updateCart();
}

function updateCart() {
    cartContainer.innerHTML = "";
    let total = 0;

    cart.forEach(item => {
        const itemTotal = item.price * item.quantity;
        total += itemTotal;

        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.name}</td>
            <td>$${item.price.toFixed(2)}</td>
            <td><input type="number" min="1" value="${item.quantity}" onchange="updateQuantity(${item.id}, this.value)"></td>
            <td>$${itemTotal.toFixed(2)}</td>
            <td><button onclick="removeItem(${item.id})">Remove</button></td>
        `;
        cartContainer.appendChild(row);
    });

    grandTotal.textContent = total.toFixed(2);
}

function updateQuantity(id, qty) {
    const quantity = parseInt(qty);
    if (isNaN(quantity) || quantity < 1) {
        alert("Quantity must be a positive number!");
        updateCart();
        return;
    }
    const item = cart.find(i => i.id === id);
    item.quantity = quantity;
    updateCart();
}

function removeItem(id) {
    cart = cart.filter(i => i.id !== id);
    updateCart();
}

clearCartBtn.addEventListener("click", () => {
    cart = [];
    updateCart();
});

categoryFilter.addEventListener("change", e => displayProducts(e.target.value));

darkModeToggle.addEventListener("click", () => {
    document.body.classList.toggle("dark-mode");
    darkModeToggle.textContent =
        document.body.classList.contains("dark-mode") ? "☀️ Light Mode" : "🌙 Dark Mode";
});

displayProducts();
