const form = document.getElementById("weatherForm");
const cityInput = document.getElementById("cityInput");
const errorMessage = document.getElementById("errorMessage");

const weatherCard = document.getElementById("weatherCard");
const locationName = document.getElementById("locationName");
const weatherIcon = document.getElementById("weatherIcon");
const temperature = document.getElementById("temperature");
const description = document.getElementById("description");
const feelsLike = document.getElementById("feelsLike");
const humidity = document.getElementById("humidity");
const windSpeed = document.getElementById("windSpeed");

form.addEventListener("submit", async (e) => {
    e.preventDefault();

    const city = cityInput.value.trim();
    const units = document.querySelector("input[name='units']:checked").value;

    errorMessage.textContent = "";
    weatherCard.classList.add("hidden");

    if (!city) {
        errorMessage.textContent = "Please enter a city name.";
        return;
    }

    try {
        const res = await fetch(`/api/weather?city=${city}&units=${units}`);
        const data = await res.json();

        if (!data.success) {
            errorMessage.textContent = data.errors[0];
            return;
        }

        const w = data.data;

        locationName.textContent = `${w.name}, ${w.country}`;
        temperature.textContent = `Temperature: ${w.temp}°`;
        description.textContent = w.description;
        feelsLike.textContent = w.feels_like;
        humidity.textContent = w.humidity;
        windSpeed.textContent = w.wind_speed;
        weatherIcon.src = `https://openweathermap.org/img/wn/${w.icon}@2x.png`;

        weatherCard.classList.remove("hidden");

    } catch (err) {
        errorMessage.textContent = "Error fetching weather.";
    }
});
